

dat$weekfac = as.factor(dat$week)

dat$postel = ifelse(dat$week < 12, "Pre", "Post")
dat$postel = factor(dat$postel, levels = c("Pre", "Post"))


convert_week <- function(week) {

  maxweek = max(week)
  weeklab = rep(NA, length(week))
  
  w1 = as.Date("27-11-2023", format="%d-%m-%Y")
  vec = NULL

    for (i in 1:maxweek) {
    
      if (i == 13) next;
      t = w1 + ((i-1) * 7)
      d = format(t, "%d")
      m = substr(format(t, "%B"), 1, 3)
      dm = paste0(d,"-",m)
      weeklab[week == i] = dm
    
      vec = c(vec, dm)
  }
  
  weeklab = factor(weeklab, levels = vec)
  
  return (weeklab)
}


### create week labels
dat$week = as.numeric(dat$week)
dat$weeklab = convert_week(dat$week)

dat = dat[order(dat$week), ]


############################################################################################
### demographic

### gender
dat$female = as.numeric(dat$demog_sex == 1)
dat$femalefac = factor(dat$female,
                       levels = c("0", "1"))

### marital
dat$demog_marital = as.numeric(dat$demog_marital)
dat$maritalfac = car::recode(dat$demog_marital,
                             "1 = 'Single';
                             2 = 'Married';
                             3 = 'Divorced';
                             4 = 'Widowed'")
dat$maritalfac = factor(dat$maritalfac,
                        levels = c("Single", "Married", "Divorced", "Widowed"))
dat$marital2pt = car::recode(dat$demog_marital,
                             "1 = 0; 2 = 1; 3:4=0")

### age
dat$age = as.numeric(dat$demog_age)
dat$agecat = car::recode(dat$age, "seq(17,19) = 1;
                                   seq(20,29) = 2;
                                   seq(30,39) = 3;
                                   seq(40,49) = 4;
                                   seq(50,100) = 5")
dat$agecat01 = (dat$agecat-1)/4

dat$birthyear = 2024 - dat$age
dat$age_group = NA
dat$age_group = car::recode(dat$birthyear,
                            "1997:2012 = 'Gen-Z (born after 1996)';
                            1981:1996 = 'Millennials (born 1981-1996)';
                            1965:1980 = 'Gen-X (born 1965-1980)';
                            1944:1964 = 'Boomers (born 1944-1964)'")
dat$age_group = factor(dat$age_group,
                       levels = c('Boomers (born 1944-1964)',
                                  'Gen-X (born 1965-1980)',
                                  'Millennials (born 1981-1996)',
                                  'Gen-Z (born after 1996)'))

dat$age_genz_millennial = NA
dat$age_genz_millennial[dat$age_group %in% c('Gen-Z (born after 1996)', 'Millennials (born 1981-1996)')] = "Gen-Z / Millennials"
dat$age_genz_millennial[dat$age_group %in% c('Gen-X (born 1965-1980)', 'Boomers (born 1944-1964)')] = "Gen-X / Boomers"


### income
dat$income = dat$demog_income
dat$income01 = (dat$income - 1)/10

### education
dat$edu = as.numeric(dat$demog_edu)
dat$edulab = car::recode(dat$edu,
                         "1 = 'No Schooling';
                         2 = 'Primary';
                         3 = 'Junior High';
                         4 = 'Senior High';
                         5 = 'College';
                         6 = 'Post-Grad'")
dat$edulab = factor(dat$edulab, 
                    levels = c("No Schooling", "Primary", "Junior High", "Senior High", "College", "Post-Grad"))
dat$edulab3pt = car::recode(dat$edu,
                             "c(1,2,3) = 'Lower than HS';
                         4 = 'High School';
                         c(5,6) = 'College or Higher'")
dat$edulab3pt = factor(dat$edulab3pt, 
                        levels = c("Lower than HS", "High School", "College or Higher"))

dat$edu_college = as.numeric(dat$edu %in% c(5,6))
dat$edu01 = (dat$edu - 1)/5

### religion
dat$religion = as.numeric(dat$demog_religion)
dat$religionlab = car::recode(dat$religion,
                              "1 = 'Islam';
                         2 = 'Catholicism';
                         3 = 'Protestantism';
                         4 = 'Buddhism';
                         5 = 'Hinduism';
                         6 = 'Confucianism';
                         7 = 'Local Religion';
                         8 = 'None';
                         9 = 'Others'")
dat$religionlab = factor(dat$religionlab,
                         levels = c("Islam", "Catholicism", "Protestantism", "Buddhism", "Hinduism", 
                                    "Confucianism", "Local Religion", 
                                    "None", "Others"))
dat$religionlab3pt = car::recode(dat$religion,
                              "1 = 'Islam';
                         2:3 = 'Christianity';
                         4:9 = 'Others'")
dat$religionlab3pt = factor(dat$religionlab3pt,
                         levels = c("Islam", "Christianity", "Others"))

dat$muslim = factor(ifelse(dat$religion == 1, "Muslim", "Non-Muslim"),
                    levels = c("Muslim", "Non-Muslim"))


### ethnicity
dat$ethnicity = as.numeric(dat$demog_ethnicity)
dat$ethnicitylab = car::recode(dat$ethnicity,
                               "1 = 'Bali';
                         2 = 'Banten';
                         3 = 'Batak';
                         4 = 'Betawi';
                         5 = 'Bugis';
                         6 = 'Jawa';
                         7 = 'Madura';
                         8 = 'Melayu';
                         9 = 'Minang';
                         10 = 'Sunda';
                         11 = 'Tionghoa';
                         12 = 'Others';")
dat$ethnicitylab = factor(dat$ethnicitylab,
                          levels = c("Bali", "Banten", "Batak", "Betawi", "Bugis", 
                                     "Jawa", "Madura", "Melayu", "Minang",
                                     "Sunda", "Tionghoa", "Others"))
dat$javanese = as.numeric(dat$ethnicitylab == "Jawa")
dat$javanese = factor(dat$javanese,
                      levels = c("0", "1"))

### province
dat$province = as.numeric(dat$demog_province)
dat$provincelab = car::recode(dat$province,
                              "1='Bali'; 2='Bangka-Belitung'; 3='Banten'; 4='Bengkulu';
                           5='D.I. Yogyakarta'; 6='DKI Jakarta'; 7='Gorontalo'; 8='Jambi';
                           9='Jawa Barat'; 10='Jawa Tengah'; 11='Jawa Timur'; 12='Kalimantan Barat';
                           13='Kalimantan Selatan'; 14='Kalimantan Tengah'; 15='Kalimantan Timur'; 16='Kalimantan Utara';
                           17='Kepulauan Riau'; 18='Lampung'; 19='Maluku'; 20='Maluku Utara';
                           21='Nanggroe Aceh'; 22='NTB'; 23='NTT'; 24='Papua';
                           25='Papua Barat'; 26='Riau'; 27='Sulawesi Barat'; 28='Sulawesi Selatan';
                           29='Sulawesi Tengah'; 30='Sulawesi Tenggara'; 31='Sulawesi Utara'; 32='Sumatera Barat';
                           33='Sumatera Selatan'; 34='Sumatera Utara'")
dat$javaisland = ifelse(dat$provincelab %in% c("Banten", "D.I. Yogyakarta", "DKI Jakarta",
                                               "Jawa Barat", "Jawa Tengah", "Jawa Timur"),
                        1, 0)
dat$javaislandlab = ifelse(dat$javaisland == 1, "Java Island", "Outside Java Island")

vec_nonmuslim = c("Bali", "NTT", "Papua", "Papua Barat", "Sulawesi Utara")
dat$muslim_geo = "Muslims in Muslim Provinces"
dat$muslim_geo[dat$demog_religion==1 & dat$provincelab %in% vec_nonmuslim] = "Muslims in Non-Muslim Provinces"
dat$muslim_geo[dat$demog_religion!=1 & !(dat$provincelab %in% vec_nonmuslim)] = "Non-Muslims in Muslim Provinces"
dat$muslim_geo[dat$demog_religion!=1 & dat$provincelab %in% vec_nonmuslim] = "Non-Muslims in Non-Muslim Provinces"
dat$muslim_geo = factor(dat$muslim_geo,
                        levels = c("Muslims in Muslim Provinces",
                                   "Muslims in Non-Muslim Provinces",
                                   "Non-Muslims in Muslim Provinces",
                                   "Non-Muslims in Non-Muslim Provinces"))
  

### region
dat$region = NA
index = which(dat$provincelab %in% 
                c("Bali", "Banten", "D.I. Yogyakarta", "DKI Jakarta", 
                  "Jawa Barat", "Jawa Tengah", "Jawa Timur"))
dat$region[index] = "Java & Bali"

index = which(dat$provincelab %in% 
                c("Bangka-Belitung", "Bengkulu", "Jambi", "Kepulauan Riau", "Lampung", "Nanggroe Aceh",
                  "Riau", "Sumatera Barat", "Sumatera Selatan", "Sumatera Utara"))
dat$region[index] = "Sumatera"


index = which(dat$provincelab %in% 
                c("Gorontalo", "Kalimantan Barat", "Kalimantan Selatan", "Kalimantan Tengah", 
                  "Kalimantan Timur", "Kalimantan Utara", "Maluku", "Maluku Utara", "NTB", "NTT",
                  "Papua", "Papua Barat", "Sulawesi Barat", "Sulawesi Selatan", "Sulawesi Tengah",
                  "Sulawesi Tenggara", "Sulawesi Utara"))
dat$region[index] = "Central & Eastern"

dat$region = factor(dat$region,
                    levels = c("Java & Bali", "Sumatera", "Central & Eastern"))

dat$region_sumatera = dat$region_eastern = 0
dat$region_sumatera[dat$region == "Sumatera"] = 1
dat$region_eastern[dat$region == "Central & Eastern"] = 1



##### majority / minority on province level

dat$isrelmajority = 0
vec_nonmuslim = c("Bali", "NTT", "Papua", "Papua Barat", "Sulawesi Utara")
vec_christ = c("NTT", "Papua", "Papua Barat", "Sulawesi Utara")
vec_muslim = unique(dat$provincelab)[which(!(unique(dat$provincelab) %in% vec_nonmuslim))]

# muslims in muslim-majority provinces are majority
idx = which(dat$religionlab == "Islam" & dat$provincelab %in% vec_muslim)
dat$isrelmajority[idx] = 1

# christians in christian-majority provinces are majority
idx = which(dat$religionlab %in% c("Catholicism", "Protestantism") & dat$provincelab %in% vec_christ)
dat$isrelmajority[idx] = 1

# hindu in bali are majority
idx = which(dat$religionlab == "Hinduism" & dat$provincelab == "Bali")
dat$isrelmajority[idx] = 1


#### province religious majority
dat$prov_relmajority = "Muslim"
idx = which(dat$provincelab %in% vec_christ)
dat$prov_relmajority[idx] = "Christian"
idx = which(dat$provincelab == "Bali")
dat$prov_relmajority[idx] = "Hindu"

dat$prov_relmajority = factor(dat$prov_relmajority,
                              levels = c("Muslim", "Christian", "Hindu"))

############################################################################################
### electoral violence
dat$elecint_violence_fraud2pt = car::recode(dat$elecint_violence_fraud,
                                             "c(1,2) = 0;
                                             c(3,4) = 1")
dat$elecint_violence_opposing2pt = car::recode(dat$elecint_violence_opposing,
                                                "c(1,2) = 0;
                                             c(3,4) = 1")
dat$elecint_violence_supporting2pt = car::recode(dat$elecint_violence_supporting,
                                                  "c(1,2) = 0;
                                             c(3,4) = 1")
dat$elecint_violence_countering2pt = car::recode(dat$elecint_violence_countering,
                                                  "c(1,2) = 0;
                                             c(3,4) = 1")

cols = c("elecint_violence_fraud", "elecint_violence_opposing", 
         "elecint_violence_supporting")
dat$elecviolence = rowMeans(dat[,cols], na.rm=TRUE)

cols = c("elecint_violence_fraud2pt", "elecint_violence_opposing2pt", 
         "elecint_violence_supporting2pt")
dat$elecviolence2pt = rowMeans(dat[,cols], na.rm=TRUE)



############################################################################################
### vote preference
dat$polpref_votepres = as.numeric(dat$polpref_votepres)
dat$polpref_votepresb = as.numeric(dat$polpref_votepresb)

dat$polpref_votepresb = car::recode(dat$polpref_votepresb, "4 = 5")
dat$polpref_votepres[dat$week >= 12] = dat$polpref_votepresb[dat$week >= 12]

dat$polpref_votepreslab = car::recode(dat$polpref_votepres,
                                      "1 = 'Anies Baswedan';
                               2 = 'Prabowo Subianto';
                               3 = 'Ganjar Pranowo';
                               4 = 'Undecided';
                               5 = 'Did Not Vote'")
dat$polpref_votepreslab = factor(dat$polpref_votepreslab,
                                 levels = c("Undecided", "Did Not Vote",
                                            "Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))

dat$polpref_votepreslab3pt = car::recode(dat$polpref_votepres,
                                         "1 = 'Anies Baswedan';
                               2 = 'Prabowo Subianto';
                               3 = 'Ganjar Pranowo';
                               4:5 = NA")
dat$polpref_votepreslab3pt = factor(dat$polpref_votepreslab3pt,
                                    levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))


dat$polpref_votepreslab4pt = car::recode(dat$polpref_votepres,
                              "1 = 'Anies Baswedan';
                               2 = 'Prabowo Subianto';
                               3 = 'Ganjar Pranowo';
                               4:5 = 'Undecided/Did Not Vote'")
dat$polpref_votepreslab4pt = factor(dat$polpref_votepreslab4pt,
                                 levels = c("Undecided/Did Not Vote",
                                            "Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))

                                                                   

dat$vote_anies3pt = car::recode(dat$polpref_votepres,
                               "1=1; 2=0; 3=0; 4:5=NA")
dat$vote_prabowo3pt = car::recode(dat$polpref_votepres,
                               "1=0; 2=1; 3=0; 4:5=NA")
dat$vote_ganjar3pt = car::recode(dat$polpref_votepres,
                               "1=0; 2=0; 3=1; 4:5=NA")

dat$vote_anies4pt = car::recode(dat$polpref_votepres,
                                "1=1; 2=0; 3=0; 4:5=0")
dat$vote_prabowo4pt = car::recode(dat$polpref_votepres,
                                  "1=0; 2=1; 3=0; 4:5=0")
dat$vote_ganjar4pt = car::recode(dat$polpref_votepres,
                                 "1=0; 2=0; 3=1; 4:5=0")

dat$polpref_jokowisatis = as.numeric(dat$polpref_jokowisatis)
dat$polpref_jokowisatis01 = (dat$polpref_jokowisatis-1)/3
dat$polpref_jokowisatis2pt = car::recode(dat$polpref_jokowisatis,
                                         "1:2=0; 3:4=1")

############################################################################################
### vote prediction
dat$polpref_prespredict = as.numeric(dat$polpref_prespredict)
dat$polpref_prespredictb = as.numeric(dat$polpref_prespredictb)

dat$polpref_prespredict[dat$week >= 12] = dat$polpref_prespredictb[dat$week >= 12]
dat$polpref_prespredictlab = car::recode(dat$polpref_prespredict,
                                         "1 = 'Anies Baswedan';
                               2 = 'Prabowo Subianto';
                               3 = 'Ganjar Pranowo'"
)
dat$polpref_prespredictlab = factor(dat$polpref_prespredictlab,
                                    levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))

dat$predictdefeat = as.numeric(dat$polpref_prespredict == 2)
dat$predictdefeat[dat$polpref_votepreslab %in% c("Prabowo Subianto", "Undecided", "Did Not Vote")] = NA



############################################################################################
### primary identity
dat$identity_primary = as.numeric(dat$identity_primary)

dat$id_choice10pt = NA
dat$id_choice10pt = car::recode(dat$identity_primary,
                                "1 = 'Ethnicity';
                                 2 = 'Religion';
                                 3 = 'Occupation';
                                 4 = 'Gender';
                                 5 = 'Economic Status';
                                 6 = 'Education';
                                 7 = 'Political Ideology';
                                 8 = 'Citizenship';
                                 9 = 'Vote Preference';
                                 c(10,11) = 'Others or None'")
dat$id_choice10pt = factor(dat$id_choice10pt,
                           levels = c("Ethnicity", "Religion", "Occupation",
                                      "Gender", "Economic Status", "Education",
                                      "Political Ideology", "Citizenship",
                                      "Vote Preference", "Others or None"))


dat$id_choice5pt = NA
dat$id_choice5pt = car::recode(dat$identity_primary,
                               "c(1,2) = 'Ethnoreligious';
                                c(3,5,6) = 'Socioeconomic';
                                c(7,9) = 'Political';
                                8 = 'Citizenship';
                                c(4,10,11) = 'Others or None'")
dat$id_choice5pt = factor(dat$id_choice5pt,
                          levels = c("Citizenship", "Ethnoreligious", "Socioeconomic",
                                     "Political", "Others or None"))


### accommodate identity splitting (week 52 onwards)
dat$id_choice10ptB = rowMeans(dat[, c("identity_primary", "identity_primaryb")], na.rm=TRUE)
dat$id_choice10ptB = car::recode(dat$id_choice10ptB,
                                "1 = 'Ethnicity';
                                 2 = 'Religion';
                                 3 = 'Occupation';
                                 4 = 'Gender';
                                 5 = 'Economic Status';
                                 6 = 'Education';
                                 7 = 'Political Ideology';
                                 8 = 'Citizenship';
                                 9 = 'Vote Preference';
                                 c(10,11) = 'Others or None'")
dat$id_choice10ptB = factor(dat$id_choice10ptB,
                           levels = c("Ethnicity", "Religion", "Occupation",
                                      "Gender", "Economic Status", "Education",
                                      "Political Ideology", "Citizenship",
                                      "Vote Preference", "Others or None"))

dat$id_choice5ptB = rowMeans(dat[, c("identity_primary", "identity_primaryb")], na.rm=TRUE)
dat$id_choice5ptB = car::recode(dat$id_choice5ptB,
                               "c(1,2) = 'Ethnoreligious';
                                c(3,5,6) = 'Socioeconomic';
                                c(7,9) = 'Political';
                                8 = 'Citizenship';
                                c(4,10,11) = 'Others or None'")
dat$id_choice5ptB = factor(dat$id_choice5ptB,
                          levels = c("Citizenship", "Ethnoreligious", "Socioeconomic",
                                     "Political", "Others or None"))


dat$id_citizenship = ifelse(dat$id_choice5pt == "Citizenship", 1, 0)
dat$id_political = ifelse(dat$id_choice5pt == "Political", 1, 0)
dat$id_ethnoreligious = ifelse(dat$id_choice5pt == "Ethnoreligious", 1, 0)
dat$id_rel = ifelse(dat$id_choice10pt == "Religion", 1, 0)


############################################################################################

dat$identity_natpride2pt = car::recode(dat$identity_natpride,
                                       "1:2=0; 3:4=1")

### what makes indonesian
dat$identity_makeidn = as.numeric(dat$identity_makeidn)

dat$makeidn9pt = NA
dat$makeidn9pt = car::recode(dat$identity_makeidn,
                                "1 = 'Birthplace';
                                 2 = 'Citizenship';
                                 3 = 'Residence';
                                 4 = 'Language';
                                 5 = 'Muslim';
                                 6 = 'Respecting Laws';
                                 7 = 'Feeling Indonesian';
                                 8 = 'Ancestry';
                                 9 = 'Pribumi'")
dat$makeidn9pt = factor(dat$makeidn9pt,
                           levels = c("Birthplace", "Citizenship", "Residence",
                                      "Language", "Muslim", "Respecting Laws",
                                      "Feeling Indonesian", "Ancestry",
                                      "Pribumi"))
dat$makeidn_muslim = ifelse(dat$identity_makeidn == 5, 1, 0)


############################################################################################
### polarization

dat$feeloutpartisan_abs = dat$feeloutpartisan_rel = NA

idx = which(dat$polpref_votepres == 1)
dat$feeloutpartisan_abs[idx] = 
  rowMeans(dat[idx, c("feelpol_groups_prabowo", "feelpol_groups_ganjar")], na.rm=TRUE)
dat$feeloutpartisan_rel[idx] = 
  dat$feelpol_groups_anies[idx] - rowMeans(dat[idx, c("feelpol_groups_prabowo", "feelpol_groups_ganjar")], na.rm=TRUE)

idx = which(dat$polpref_votepres == 2)
dat$feeloutpartisan_abs[idx] = 
  rowMeans(dat[idx, c("feelpol_groups_anies", "feelpol_groups_ganjar")], na.rm=TRUE)
dat$feeloutpartisan_rel[idx] = 
  dat$feelpol_groups_prabowo[idx] - rowMeans(dat[idx, c("feelpol_groups_anies", "feelpol_groups_ganjar")], na.rm=TRUE)

idx = which(dat$polpref_votepres == 3)
dat$feeloutpartisan_abs[idx] = 
  rowMeans(dat[idx, c("feelpol_groups_anies", "feelpol_groups_prabowo")], na.rm=TRUE)
dat$feeloutpartisan_rel[idx] = 
  dat$feelpol_groups_ganjar[idx] - rowMeans(dat[idx, c("feelpol_groups_anies", "feelpol_groups_prabowo")], na.rm=TRUE)


dat$feelinpartisan = NA
idx = which(dat$polpref_votepres == 1)
dat$feelinpartisan[idx] = dat$feelpol_groups_anies[idx]
idx = which(dat$polpref_votepres == 2)
dat$feelinpartisan[idx] = dat$feelpol_groups_prabowo[idx]
idx = which(dat$polpref_votepres == 3)
dat$feelinpartisan[idx] = dat$feelpol_groups_ganjar[idx]


dat$feeldiff_inpartisan_prabowo = dat$feelinpartisan - dat$feelpol_groups_prabowo 
  

############################################################################################
### information sources

dat$infosource_onlinenews = as.numeric(dat$misinfo_infosource_onlinenews)
dat$infosource_printed = as.numeric(dat$misinfo_infosource_printed)

dat$infosource_printed2pt = car::recode(dat$misinfo_infosource_printed,
                                        "1:4 = 0; 5=1")
dat$infosource_tv2pt = car::recode(dat$misinfo_infosource_tv,
                                        "1:4 = 0; 5=1")
dat$infosource_onlinenews2pt = car::recode(dat$misinfo_infosource_onlinenews,
                                        "1:4 = 0; 5=1")
dat$infosource_facebook2pt = car::recode(dat$misinfo_infosource_facebook,
                                        "1:4 = 0; 5=1")
dat$infosource_twitter2pt = car::recode(dat$misinfo_infosource_twitter,
                                        "1:4 = 0; 5=1")
dat$infosource_tiktok2pt = car::recode(dat$misinfo_infosource_tiktok,
                                        "1:4 = 0; 5=1")
dat$infosource_instagram2pt = car::recode(dat$misinfo_infosource_instagram,
                                        "1:4 = 0; 5=1")


cols = c("misinfo_infosource_instagram", "misinfo_infosource_facebook", 
         "misinfo_infosource_twitter", "misinfo_infosource_tiktok")
dat$infosource_socmed = rowMeans(dat[, cols], na.rm=TRUE)


cols = c("misinfo_infosource_printed", "misinfo_infosource_onlinenews", 
         "misinfo_infosource_tv")
dat$infosource_traditional = rowMeans(dat[, cols], na.rm=TRUE)

dat$infodiff_socmed_traditional = dat$infosource_socmed - dat$infosource_traditional

cols = c("infosource_instagram2pt", "infosource_facebook2pt", 
         "infosource_twitter2pt", "infosource_tiktok2pt")
dat$infosource_socmed04 = rowSums(dat[, cols], na.rm=TRUE)


cols = c("misinfo_infosource_printed", "misinfo_infosource_tv", "misinfo_infosource_onlinenews", 
         "misinfo_infosource_instagram", "misinfo_infosource_facebook", 
         "misinfo_infosource_twitter", "misinfo_infosource_tiktok")
dat$infosource_all = rowMeans(dat[, cols], na.rm=TRUE)


############################################################################################
### trust on different information sources


dat$trustinfo_printed2pt = car::recode(dat$misinfo_trustsource_printed,
                                        "1:2 = 0; 3:4=1")
dat$trustinfo_tv2pt = car::recode(dat$misinfo_infosource_tv,
                                  "1:2 = 0; 3:4=1")
dat$trustinfo_onlinenews2pt = car::recode(dat$misinfo_trustsource_online,
                                          "1:2 = 0; 3:4=1")
dat$trustinfo_facebook2pt = car::recode(dat$misinfo_trustsource_facebook,
                                        "1:2 = 0; 3:4=1")
dat$trustinfo_twitter2pt = car::recode(dat$misinfo_trustsource_twitter,
                                       "1:2 = 0; 3:4=1")
dat$trustinfo_tiktok2pt = car::recode(dat$misinfo_trustsource_tiktok,
                                      "1:2 = 0; 3:4=1")
dat$trustinfo_instagram2pt = car::recode(dat$misinfo_trustsource_instagram,
                                         "1:2 = 0; 3:4=1")

dat$trustinfo_fb_printed = as.numeric(dat$misinfo_trustsource_facebook > dat$misinfo_trustsource_printed)
dat$trustinfo_ig_printed = as.numeric(dat$misinfo_trustsource_instagram > dat$misinfo_trustsource_printed)
dat$trustinfo_twitter_printed = as.numeric(dat$misinfo_trustsource_twitter > dat$misinfo_trustsource_printed)
dat$trustinfo_tiktok_printed = as.numeric(dat$misinfo_trustsource_tiktok > dat$misinfo_trustsource_printed)

############################################################################################
### electoral integrity

dat$elecint_event_integrity[dat$week > 11] = dat$elecint_eventb_integrity[dat$week > 11]
dat$elecint_event_opposition[dat$week > 11] = dat$elecint_eventb_opposition[dat$week > 11]
dat$elecint_event_bribe[dat$week > 11] = dat$elecint_eventb_bribe[dat$week > 11]
dat$elecint_event_partisanship[dat$week > 11] = dat$elecint_eventb_partisanship[dat$week > 11]
dat$elecint_event_threat[dat$week > 11] = dat$elecint_eventb_threat[dat$week > 11]


dat$elecint_event_opposition = car::recode(dat$elecint_event_opposition,
                                           "1=4; 2=3; 3=2; 4=1")
dat$elecint_event_bribe = car::recode(dat$elecint_event_bribe,
                                           "1=4; 2=3; 3=2; 4=1")
dat$elecint_event_partisanship = car::recode(dat$elecint_event_partisanship,
                                           "1=4; 2=3; 3=2; 4=1")
dat$elecint_event_threat = car::recode(dat$elecint_event_threat,
                                           "1=4; 2=3; 3=2; 4=1")

cols = c("elecint_event_opposition", "elecint_event_bribe", "elecint_event_partisanship",
         "elecint_event_threat")
dat$elecintegrity = rowMeans(dat[, cols], na.rm=TRUE)


############################################################################################
### political knowledge

dat$knowledge_review01 = ifelse(dat$knowledge_review == 1, 1, 0)
dat$knowledge_amendment01 = ifelse(dat$knowledge_amendment == 4, 1, 0)
dat$knowledge_mpr01 = ifelse(dat$knowledge_mpr == 1, 1, 0)
dat$knowledge_vp01 = ifelse(dat$knowledge_vp == 1, 1, 0)
dat$knowledge_jkwparty01 = ifelse(dat$knowledge_jkwparty == 1, 1, 0)
dat$knowledge_dprtermlim01 = ifelse(dat$knowledge_dprtermlim == 5, 1, 0)
dat$knowledge_elecdispute01 = ifelse(dat$knowledge_elecdisput == 1, 1, 0)
dat$knowledge_unsc01 = ifelse(dat$knowledge_unsc == 5, 1, 0)
dat$knowledge_leader01 = ifelse(dat$knowledge_leader == 1, 1, 0)

cols = c("knowledge_review01", "knowledge_amendment01", "knowledge_mpr01", "knowledge_vp01",
         "knowledge_jkwparty01", "knowledge_dprtermlim01", "knowledge_elecdispute01", 
         "knowledge_unsc01", "knowledge_leader01")
# dat[,cols] = apply(dat[,cols], 2, function(x) ifelse(is.na(x), 0, x))

dat$polknowledge = rowSums(dat[,cols], na.rm=TRUE)

cols = c("knowledge_review01", "knowledge_amendment01", "knowledge_mpr01", "knowledge_dprtermlim01", "knowledge_elecdispute01")
dat$polknowledge5 = rowSums(dat[,cols])

dat$polknowledge[dat$week %% 2 == 1] = NA
dat$polknowledge5[dat$week %% 2 == 1] = NA

dat$polknowledge[dat$week > 18] = NA
dat$polknowledge5[dat$week > 18] = NA



############################################################################################
### institutional trust

cols = c("trustinst_inst_president", "trustinst_inst_tni", "trustinst_inst_polri", "trustinst_inst_dpr",
         "trustinst_inst_mk", "trustinst_inst_kpu")

dat$trustinst = rowMeans(dat[, cols], na.rm=TRUE)

dat$trustinst_inst_president2pt = car::recode(dat$trustinst_inst_president,
                                              "1:2=0; 3:4=1")
dat$trustinst_inst_tni2pt = car::recode(dat$trustinst_inst_tni,
                                              "1:2=0; 3:4=1")
dat$trustinst_inst_polri2pt = car::recode(dat$trustinst_inst_polri,
                                              "1:2=0; 3:4=1")
dat$trustinst_inst_dpr2pt = car::recode(dat$trustinst_inst_dpr,
                                              "1:2=0; 3:4=1")
dat$trustinst_inst_mk2pt = car::recode(dat$trustinst_inst_mk,
                                              "1:2=0; 3:4=1")
dat$trustinst_inst_kpu2pt = car::recode(dat$trustinst_inst_kpu,
                                              "1:2=0; 3:4=1")


############################################################################################
### civil society trust

cols = c("trustciv_groups_journalist", "trustciv_groups_religiousleader", "trustciv_groups_scientist", 
         "trustciv_groups_activist")

dat$trustcivsoc = rowMeans(dat[, cols], na.rm=TRUE)


cols = c("trustciv_groups_journalist", "trustciv_groups_scientist", 
         "trustciv_groups_activist")

dat$trustcivsoc_norel = rowMeans(dat[, cols], na.rm=TRUE)



############################################################################################
### support for democracy

dat$democ_satisfied01 = (dat$democ_satisfied-1)/3
dat$democ_suitable01 = (dat$democ_suitable-1)/5

dat$democ_satisfied2pt = car::recode(dat$democ_satisfied,
                                     "1:2 = 0; 3:4 = 1")
dat$democ_suitable2pt = car::recode(dat$democ_suitable,
                                     "1:3 = 0; 4:6 = 1")

dat$democ_characteristic_election2pt = car::recode(dat$democ_characteristic_election,
                                 "1:4 = 0; 5:6 = 1")
dat$democ_characteristic_military2pt = car::recode(dat$democ_characteristic_military,
                                 "1:4 = 0; 5:6 = 1")
dat$democ_characteristic_obey2pt = car::recode(dat$democ_characteristic_obey,
                                 "1:4 = 0; 5:6 = 1")
dat$democ_characteristic_religion2pt = car::recode(dat$democ_characteristic_religion,
                                 "1:4 = 0; 5:6 = 1")
dat$democ_characteristic_rights2pt = car::recode(dat$democ_characteristic_rights,
                                 "1:4 = 0; 5:6 = 1")


############################################################################################
### political participation

dat$polint_activities_protest2pt = car::recode(dat$polint_activities_protest,
                                               "1:3=0; 4=1")

dat$polint_activities_persuade2pt = car::recode(dat$polint_activities_persuade,
                                                "1:3=0; 4=1")

dat$polint_activities_campaign2pt = car::recode(dat$polint_activities_campaign,
                                                "1:3=0; 4=1")

dat$polactivities_elect = rowSums(dat[, c("polint_activities_persuade2pt", "polint_activities_campaign2pt")], na.rm=TRUE)
dat$polactivities_all = rowSums(dat[, c("polint_activities_protest2pt",
                                        "polint_activities_persuade2pt", 
                                        "polint_activities_campaign2pt")], na.rm=TRUE)

dat$polint_interest01 = (dat$polint_interest-1)/3
dat$polint_discussion01 = (dat$polint_discussion-1)/2

dat$polint_interest2pt = NA
dat$polint_interest2pt[dat$polint_interest %in% c(1:2)] = 0
dat$polint_interest2pt[dat$polint_interest %in% c(3:4)] = 1
dat$polint_interest2ptlab = car::recode(dat$polint_interest2pt,
                                        "0 = 'Low Interest';
                                        1 = 'High Interest'")

############################################################################################
### political Islam

cols = c("polrel_polislam_priority", "polrel_polislam_ulama", "polrel_polislam_law")
dat$polislam = rowMeans(dat[,cols], na.rm=TRUE)
dat$polislam01 = (dat$polislam-1)/3


############################################################################################
### religiosity

cols_muslim = c("religiosity_muslim_quran", "religiosity_muslim_shalat", "religiosity_muslim_mosque", "religiosity_muslim_recitation")
cols_nonmuslim = c("religiosity_nonmus_pray", "religiosity_nonmus_recitation", "religiosity_nonmus_worshiphouse")


dat$religiosity_muslim = rowMeans(dat[,cols_muslim], na.rm=TRUE)
dat$religiosity_nonmuslim = rowMeans(dat[,cols_nonmuslim], na.rm=TRUE)

dat$religiosity = rowMeans(dat[,c(cols_muslim, cols_nonmuslim)], na.rm=TRUE)
dat$religiosity01 = (dat$religiosity-1)/5

dat$religiosity_muslim_mosque01 = (dat$religiosity_muslim_mosque-1)/5
dat$religiosity_muslim_quran01 = (dat$religiosity_muslim_quran-1)/5
dat$religiosity_muslim_shalat01 = (dat$religiosity_muslim_shalat-1)/5
dat$religiosity_muslim_recitation01 = (dat$religiosity_muslim_recitation-1)/5

############################################################################################
### religious intolerance

cols = c("relintol_muslim_worship", "relintol_muslim_worshiphouse", "relintol_muslim_leader", "relintol_muslim_rt", 
         "relintol_nonmuslim_worship", "relintol_nonmuslim_worshiphouse", "relintol_nonmuslim_leader", "relintol_nonmuslim_rt",
         "relintol_neighbor")

dat$relintol = rowMeans(dat[,cols], na.rm=TRUE)
dat$relintol01 = (dat$relintol-1)/3

############################################################################################
### intoleran behavior


dat$intolbehav_muslim = as.numeric(dat$tolbehav_muslim == 0)
dat$intolbehav_nonmuslim = as.numeric(dat$tolbehav_nonmuslim == 0)
dat$intolbehav = rowMeans(dat[, c("intolbehav_muslim", "intolbehav_nonmuslim")], na.rm=TRUE)


############################################################################################
### religiosity

cols_muslim = c("religiosity_muslim_quran", "religiosity_muslim_shalat", "religiosity_muslim_mosque")
cols_nonmuslim = c("religiosity_nonmus_pray", "religiosity_nonmus_recitation", "religiosity_nonmus_worshiphouse")

dat$religiosity_muslim = rowMeans(dat[,cols_muslim], na.rm=TRUE)
dat$religiosity_nonmuslim = rowMeans(dat[,cols_nonmuslim], na.rm=TRUE)

dat$religiosity = rowMeans(dat[,c(cols_muslim, cols_nonmuslim)], na.rm=TRUE)


############################################################################################
### ethnoreligious feelings

cols_old = c("feelethno_groups_agnostic", "feelethno_groups_arab", "feelethno_groups_islam",
             "feelethno_groups_christian", "feelethno_groups_tionghoa")

cols_new = c("dislike_agnostic", "dislike_arab", "dislike_islam",
             "dislike_christian", "dislike_tionghoa")
dat[,cols_new] = apply(dat[,cols_old], 2, function(x) car::recode(x, "1=5; 2=4; 3=3; 4=2; 5=1"))

cols_new = c("dislike_agnostic2pt", "dislike_arab2pt", "dislike_islam2pt",
             "dislike_christian2pt", "dislike_tionghoa2pt")
dat[,cols_new] = apply(dat[,cols_old], 2, function(x) car::recode(x, "1=1; 2=1; 3=0; 4=0; 5=0"))


### feeling ingroup - outgroup (Christians and Muslims only)
dat$feel_relingroup = dat$feel_reloutgroup = NA

dat$feel_relingroup[dat$demog_religion == 1] = 
  dat$feelethno_groups_islam[dat$demog_religion == 1]
dat$feel_relingroup[dat$demog_religion %in% c(2:3)] = 
  dat$feelethno_groups_christian[dat$demog_religion %in% c(2:3)]


dat$feel_reloutgroup[dat$demog_religion == 1] = 
  dat$feelethno_groups_christian[dat$demog_religion == 1]
dat$feel_reloutgroup[dat$demog_religion %in% c(2:3)] = 
  dat$feelethno_groups_islam[dat$demog_religion  %in% c(2:3)]


############################################################################################
### country feelings

cols = c("feelcty_countries_malaysia", "feelcty_countries_us", "feelcty_countries_china", "feelcty_countries_arab",
         "feelcty_countries_australia", "feelcty_countries_india")
dat$feelcty = rowMeans(dat[,cols], na.rm=TRUE)



############################################################################################
### inclusive sermons

dat$polrel_sermoninclusive = as.numeric(rowSums(dat[, c("polrel_sermontoleran", "polrel_sermonunity")], na.rm=TRUE) >= 1)


############################################################################################
### bonding

dat$net_friendrel2pt = car::recode(dat$net_friendrel, "1:4=0; 5=1")
dat$net_neighborrel2pt = car::recode(dat$net_neighborrel, "1:4=0; 5=1")
dat$net_workrel2pt = car::recode(dat$net_workrel, "1:4=0; 5=1")

dat$net_context2pt = as.numeric((dat$net_neighborrel2pt & dat$net_workrel2pt) |
                                  (is.na(dat$net_neighborrel2pt) & dat$net_workrel2pt == 1) |
                                  (dat$net_neighborrel2pt == 1 & is.na(dat$net_workrel2pt)))



################################### party placement #####################################

dat$ptyplace_islam_pdip = dat$ptyplace_islam_1
dat$ptyplace_islam_golkar = dat$ptyplace_islam_2
dat$ptyplace_islam_demokrat = dat$ptyplace_islam_3
dat$ptyplace_islam_gerindra = dat$ptyplace_islam_4
dat$ptyplace_islam_pks = dat$ptyplace_islam_5
dat$ptyplace_islam_pkb = dat$ptyplace_islam_6
dat$ptyplace_islam_nasdem = dat$ptyplace_islam_7
dat$ptyplace_islam_pan = dat$ptyplace_islam_8

dat$ptyplace_gender_pdip = dat$ptyplace_gender_1
dat$ptyplace_gender_golkar = dat$ptyplace_gender_2
dat$ptyplace_gender_demokrat = dat$ptyplace_gender_3
dat$ptyplace_gender_gerindra = dat$ptyplace_gender_4
dat$ptyplace_gender_pks = dat$ptyplace_gender_5
dat$ptyplace_gender_pkb = dat$ptyplace_gender_6
dat$ptyplace_gender_nasdem = dat$ptyplace_gender_7
dat$ptyplace_gender_pan = dat$ptyplace_gender_8

dat$ptyplace_poor_pdip = dat$ptyplace_poor_1
dat$ptyplace_poor_golkar = dat$ptyplace_poor_2
dat$ptyplace_poor_demokrat = dat$ptyplace_poor_3
dat$ptyplace_poor_gerindra = dat$ptyplace_poor_4
dat$ptyplace_poor_pks = dat$ptyplace_poor_5
dat$ptyplace_poor_pkb = dat$ptyplace_poor_6
dat$ptyplace_poor_nasdem = dat$ptyplace_poor_7
dat$ptyplace_poor_pan = dat$ptyplace_poor_8

dat$ptyplace_orba_pdip = dat$ptyplace_orba_1
dat$ptyplace_orba_golkar = dat$ptyplace_orba_2
dat$ptyplace_orba_demokrat = dat$ptyplace_orba_3
dat$ptyplace_orba_gerindra = dat$ptyplace_orba_4
dat$ptyplace_orba_pks = dat$ptyplace_orba_5
dat$ptyplace_orba_pkb = dat$ptyplace_orba_6
dat$ptyplace_orba_nasdem = dat$ptyplace_orba_7
dat$ptyplace_orba_pan = dat$ptyplace_orba_8


############################################################################################
### resentment

cols_old = c("resent_islam_disparity", "resent_islam_discrimination", "resent_islam_influence")
cols_new = c("resent_islam_disparity01", "resent_islam_discrimination01", "resent_islam_influence01")
dat[, cols_new] = (dat[,cols_old]-1)/3

cols = c("resent_islam_disparity", "resent_islam_discrimination", "resent_islam_influence")
dat$resent_islam = rowMeans(dat[,cols], na.rm=TRUE)
dat$resent_islam01 = (dat$resent_islam-1)/3

cols = c("resent_java_priority", "resent_java_neglect", "resent_java_influence")
dat$resent_java_priority_rev = car::recode(dat$resent_java_priority,
                                       "1=4; 2=3; 3=2; 4=1")
cols = c("resent_java_priority_rev", "resent_java_neglect", "resent_java_influence")
dat$resent_java = rowMeans(dat[,cols], na.rm=TRUE)
dat$resent_java01 = (dat$resent_java-1)/3


cols = c("resent_chinese_opportunity", "resent_chinese_money", "resent_chinese_influence", "resent_chinese_easylife")
dat$resent_chinese = rowMeans(dat[,cols], na.rm=TRUE)
dat$resent_chinese01 = (dat$resent_chinese-1)/3


############################################################################################
### gender and redistribution

cols = c("genredist_gender_leader", "genredist_gender_education", "genredist_gender_job")
dat$tradgender = rowMeans(dat[,cols], na.rm=TRUE)
