
library(ggridges)

sikap_df <- dat
sikap_df <- haven::zap_labels(sikap_df)

str(sikap_df$demog_income)

democ_factor <-
  sikap_df %>%
  filter(week %in% c(11)) %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997\u2013)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981\u201396)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965\u201380)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944\u201364)"),
         vote_choice = coalesce(polpref_votepres, polpref_votepresb),
         vote_choice = case_when(vote_choice == 1 ~ "Anies Baswedan",
                                 vote_choice == 2 ~ "Prabowo Subianto",
                                 vote_choice == 3 ~ "Ganjar Pranowo",
                                 vote_choice == 4 ~ NA_character_),
         age_cat = factor(age_cat, levels = c("Boomers\n(1944\u201364)", "Gen-X\n(1965\u201380)", 
                                              "Millenials\n(1981\u201396)", "Gen-Z\n(1997\u2013)"))) %>%
#  mutate_at(vars(democ_characteristic_military, democ_characteristic_obey, democ_characteristic_election, democ_characteristic_rights),
#            funs(case_when(. == 1 ~ "Not at all important",
#                           . == 6 ~ "Very important",
#                           TRUE ~ as.character(.)
#                           ))) %>%
  select(age_cat, democ_characteristic_military, democ_characteristic_obey, democ_characteristic_election, democ_characteristic_rights) %>%
  pivot_longer(cols = democ_characteristic_military:democ_characteristic_rights) %>%
  mutate(name = case_when(name == "democ_characteristic_military" ~ "The military takes over\nwhen government is incompetent",
                          name == "democ_characteristic_obey" ~ "Citizens obey their government",
                          name == "democ_characteristic_election" ~ "Governments hold free and\n fair elections",
                          name == "democ_characteristic_rights" ~ "Civil rights protect citizens\nfrom abuse by the state")) %>%
  #mutate(value = factor(value, levels = c("Not at all important", "2", "3", "4", "5", "Very important"))) %>%
  ggplot(aes(x=value, y = age_cat)) +
  geom_density_ridges(alpha = 0.6) +
  xlim(1, 6) +
  facet_wrap(name ~ ., ncol = 2, scales = "free") +
  scale_x_continuous(name = "Importance of factor for democracy",
                     breaks = 1:6,
                     labels = c("1\n(Not imp.)", "2", "3", "4" ,"5", "6\n(Very imp.)")) +
  theme_bw() + 
  theme(axis.line.x.bottom = element_line(color = "black"),
        axis.line.y.left = element_blank(),
        panel.grid.major = element_blank(),
        panel.grid.minor.x = element_blank(),
        legend.position = "bottom",
        strip.background = element_blank(),
        axis.title.y = element_blank(),
        legend.title = element_blank(),
        panel.border = element_blank(),
        axis.ticks = element_blank(),
        text=element_text(size=9, family="new_bask"))




ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/democ_factor.pdf", democ_factor, width = 115, height = 115, units = "mm", dpi = 1600)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/democ_factor.pdf", democ_factor, width = 115, height = 115, units = "mm", dpi = 1600)
