sikap_df %>%
  summarise(val_counter = mean(elecint_violence_countering %in% c(3, 4), na.rm = T),
            val_oppose = mean(elecint_violence_supporting %in% c(3, 4), na.rm = T)) 

electoral_violence_figure <-
  sikap_df %>%
  group_by(demog_age, demog_sex) %>%
  summarise(val_counter = mean(elecint_violence_countering %in% c(3, 4), na.rm = T),
            val_oppose = mean(elecint_violence_supporting %in% c(3, 4), na.rm = T)) %>%
  filter(demog_sex != 2) %>%
  filter(demog_age < 70) %>%
  pivot_longer(cols = val_counter:val_oppose, names_to = "out", values_to = "est") %>%
  mutate(out_label = case_when(out == "val_oppose" ~ "Violence justified to support\npreferred presidential candidate",
                               out == "val_counter" ~ "Violence justified to stop\nimmoral actors in society")) %>%
  mutate(gender = case_when(demog_sex == 1 ~ "Women",
                            demog_sex == 0 ~ "Men")) %>%
  ggplot(aes(x=demog_age, y = est*100, group = gender, shape = gender, linetype = gender)) +
  facet_wrap(out_label~.) +
  stat_summary_bin(geom = "point", bins = 8, inherit.aes = T) +
  stat_summary_bin(geom = "line", bins = 8, inherit.aes = T) +
  theme_bw() +
  xlab("Respondent Age") +
  ylab("Respondents Agreeing or Strongly Agreeing (%)") +
  theme(panel.grid.minor = element_blank(), 
        panel.grid.major.x = element_blank(),
        #axis.text.x = element_text(angle = 90),
        #axis.line.y.left = element_blank(),
        strip.background = element_blank(),
        #text = element_text(size=30),
        axis.line = element_line(colour = "black"),
        panel.border = element_blank(),
        legend.position = "bottom",
        legend.title = element_blank())


  ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/electoral_violence_figure.pdf", electoral_violence_figure, width = 7, height = 4)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/electoral_violence_figure.pdf", electoral_violence_figure, width = 7, height = 4)
