

gender_age_plot <-
  sikap_df %>%
 # filter(week %in% c(10)) %>%
  group_by(demog_age, demog_sex) %>%
  summarise(prabowo = mean(polpref_votepres == 2, na.rm = T),
            anies = mean(polpref_votepres == 1, na.rm = T),
            ganjar = mean(polpref_votepres == 3, na.rm = T),
            tt_tj = mean(polpref_votepres == 4, na.rm = T)) %>%
  filter(demog_sex != 2) %>%
  filter(demog_age < 70) %>%
  pivot_longer(cols = prabowo:tt_tj, names_to = "cand", values_to = "est") %>%
  mutate(cand_label = case_when(cand == "prabowo" ~ "Prabowo Subianto",
                                cand == "ganjar" ~ "Ganjar Pranowo",
                                cand == "anies" ~ "Anies Baswedan",
                                cand == "tt_tj" ~ "DK/NA"),
         cand_label = factor(cand_label, levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo", "DK/NA")),
         demog_sex = case_when(demog_sex == 0 ~ "Men",
                               demog_sex == 1 ~ "Women")) %>%
  ggplot(aes(x=demog_age, y = est*100, shape = cand_label, linetype = cand_label)) +
  facet_wrap(demog_sex~.) +
  stat_summary_bin(geom = "point", bins = 8, inherit.aes = T) +
  stat_summary_bin(geom = "line", bins = 8) +
  theme_bw() +
  #ggtitle("Subset: Under 30 y.o.") +
  #ggtitle("Effect of Revealing Under/Over-Performance on Conservativism, Among Men") +
  theme(panel.grid.minor = element_blank(), 
        panel.grid.major.x = element_blank(),
        #axis.text.x = element_text(angle = 90),
        #axis.line.y.left = element_blank(),
        strip.background = element_blank(),
        #text = element_text(size=30),
        axis.line = element_line(colour = "black"),
        panel.border = element_blank(),
        legend.position = "bottom",
        axis.title.y = element_blank(),
        legend.title = element_blank()) +
  xlab("Age") +
  geom_hline(yintercept = 49.6, linetype = "dashed", color = "red")

  
ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/gender_age_plot.pdf", gender_age_plot, width = 7, height = 4)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/gender_age_plot.pdf", gender_age_plot, width = 7, height = 4)





sikap_df$demog_edu
sikap_df %>%
  mutate(univ = case_when(demog_edu %in% c(5, 6) ~ "univ",
                          TRUE ~ "no univ")) %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997\u2013)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981\u201396)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965\u201380)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944\u201364)")) %>%
  # filter(week %in% c(10)) %>%
  group_by(age_cat, demog_sex, univ) %>%
  summarise(prabowo = mean(polpref_votepres == 2, na.rm = T),
            anies = mean(polpref_votepres == 1, na.rm = T),
            ganjar = mean(polpref_votepres == 3, na.rm = T),
            tt_tj = mean(polpref_votepres == 4, na.rm = T)) %>%
  filter(demog_sex != 2) %>%
  pivot_longer(cols = prabowo:tt_tj, names_to = "cand", values_to = "est") %>%
  mutate(cand_label = case_when(cand == "prabowo" ~ "Prabowo Subianto",
                                cand == "ganjar" ~ "Ganjar Pranowo",
                                cand == "anies" ~ "Anies Baswedan",
                                cand == "tt_tj" ~ "DK/NA"),
         cand_label = factor(cand_label, levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo", "DK/NA")),
         demog_sex = case_when(demog_sex == 0 ~ "Men",
                               demog_sex == 1 ~ "Women")) %>%
  print(., n = 100)
