
library(tidyverse)

issues_important <-
  sikap_df %>%
  mutate(start_date = case_when(week == 11 ~ as.Date(str_sub(StartDate, 1, 10), "%Y-%m-%d"),
                                TRUE ~ as.Date(str_sub(startdate, 1, 10), "%Y-%m-%d"))) %>%
  group_by(week) %>%
  summarise(date = min(start_date),
            econ_dev = mean(prob_importance_devecon %in% c(4), na.rm = T),
            health = mean(prob_importance_health %in% c(4), na.rm = T),
            education = mean(prob_importance_education == 4, na.rm = T),
            climate_change = mean(prob_importance_climatechange == 4, na.rm = T)) %>%
  pivot_longer(cols = econ_dev:climate_change, names_to = "issue", values_to = 'vals') %>%
  mutate(issue = case_when(issue == "econ_dev" ~ "Economic Development",
                           issue == "education" ~ "Education",
                           issue == "health" ~ "Health",
                           issue == "climate_change" ~ "Climate Change")) %>%
  ggplot(aes(x=date, y = vals*100, group = issue, linetype = issue, shape = issue)) +
  geom_point() +
  geom_line() +
  ylim(40, 75) +
  theme_bw() +
  ylab("Respondents Saying Issue is Very Important (%)") +
  theme(panel.grid.minor = element_blank(), 
        panel.grid.major.x = element_blank(),
        #axis.text.x = element_text(angle = 90),
        #axis.line.y.left = element_blank(),
        strip.background = element_blank(),
        #text = element_text(size=30),
        axis.line = element_line(colour = "black"),
        panel.border = element_blank(),
        axis.title.x = element_blank(),
        legend.position = "bottom",
        legend.title = element_blank())

ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/important_issues.pdf", issues_important, width = 7, height = 4)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/important_issues.pdf", issues_important, width = 7, height = 4)


