sikap_df <- dat
sikap_df <- haven::zap_labels(sikap_df)


income_vote <-
  sikap_df %>%
  filter(week %in% c(11)) %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997\u2013)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981\u201396)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965\u201380)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944\u201364)"),
         vote_choice = coalesce(polpref_votepres, polpref_votepresb),
         vote_choice = case_when(vote_choice == 1 ~ "Anies Baswedan",
                                 vote_choice == 2 ~ "Prabowo Subianto",
                                 vote_choice == 3 ~ "Ganjar Pranowo",
                                 vote_choice == 4 ~ NA_character_),
         age_cat = factor(age_cat, levels = c("Boomers\n(1944\u201364)", "Gen-X\n(1965\u201380)", 
                                              "Millenials\n(1981\u201396)", "Gen-Z\n(1997\u2013)")),
         income_cat = case_when(demog_income %in% c(1, 2, 3) ~ "1\u20133m IDR",
                                demog_income %in% c(4, 5, 6) ~ "3\u20136m IDR",
                                demog_income %in% c(7, 8, 9) ~ "6\u20139m IDR",
                                TRUE ~ "9m IDR <"),
         week = case_when(week == 11 ~ "SIKAP Pre-Election (Feb 4 - 11)",
                          week == 12 ~ "SIKAP Post-Election (Feb 15 - 25)")) %>%
  filter(!is.na(vote_choice)) %>%
  group_by(income_cat, age_cat, vote_choice) %>%
  summarise(val = n()) %>%
  group_by(income_cat, age_cat) %>%
  mutate(tot = sum(val),
         prop = val/tot) %>%
  filter(vote_choice == "Prabowo Subianto") %>%
  ggplot(aes(x=fct_rev(age_cat), y = prop*100, shape = factor(income_cat), linetype = factor(income_cat), group = factor(income_cat))) +
  stat_summary_bin(geom = "point", bins = 8, inherit.aes = T) +
  stat_summary_bin(geom = "line", bins = 8) +
  scale_color_grey() +
  theme_bw()+ 
  theme(axis.line.x.bottom = element_line(color = "black"),
        axis.line.y.left = element_blank(),
        panel.grid.major.x = element_blank(),
        #panel.grid.minor.x = element_blank(),
        legend.position = "bottom",
        strip.background = element_blank(),
        axis.title.x = element_blank(),
        legend.title = element_blank(),
        panel.border = element_blank(),
        axis.ticks = element_blank( ),
        text=element_text(size=10, family="new_bask")) +
  ylab("Support for Prabowo (%)")

ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/income_vote.pdf", income_vote, width = 115, height = 70, units = "mm", dpi = 1600)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/income_vote.pdf", income_vote, width = 115, height = 70, units = "mm", dpi = 1600)
