media_age_graph <-
  sikap_df %>%
  haven::zap_labels() %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997-)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981-96)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965-80)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944-64)"),
         age_cat = factor(age_cat, levels = c("Boomers\n(1944-64)", "Gen-X\n(1965-80)", 
                                              "Millenials\n(1981-96)", "Gen-Z\n(1997-)"))) %>%
  
  select(age_cat, polpref_votepres, misinfo_infosource_tv, misinfo_infosource_tiktok, misinfo_infosource_instagram, misinfo_infosource_printed) %>%
  pivot_longer(cols = misinfo_infosource_tv:misinfo_infosource_printed, values_to = "values", names_to = "type") %>%
  mutate(type = case_when(type == 'misinfo_infosource_tv' ~ "Info Source: TV",
                          type == "misinfo_infosource_tiktok" ~ "Info Source: TikTok",
                          type == "misinfo_infosource_instagram" ~ "Info Source: Instagram",
                          type == "misinfo_infosource_printed" ~ "Info Source: Print Media",
                          TRUE ~ NA_character_)) %>%
  mutate(values = case_when(values == 5 ~ "Daily",
                            values %in% c(1, 2, 3, 4) ~ "Less Than Daily",
                            TRUE ~ NA_character_)) %>%
  group_by(type, values, age_cat) %>%
  summarise(val = mean(polpref_votepres == 2, na.rm = T)) %>%
  filter(!is.na(values)) %>%
  ggplot(aes(x=fct_rev(age_cat), y = val*100, shape = factor(values), group = factor(values), linetype = factor(values))) +
  stat_summary_bin(geom = "point", bins = 8, inherit.aes = T) +
  stat_summary_bin(geom = "line", bins = 8) +
  facet_wrap(type ~.,ncol = 2) +
  theme_bw() +
  #ggtitle("Subset: Under 30 y.o.") +
  #ggtitle("Effect of Revealing Under/Over-Performance on Conservativism, Among Men") +
  theme(panel.grid.minor = element_blank(), 
        panel.grid.major.x = element_blank(),
        #axis.text.x = element_text(angle = 90),
        #axis.line.y.left = element_blank(),
        strip.background = element_blank(),
        #text = element_text(size=30),
        axis.line = element_line(colour = "black"),
        panel.border = element_blank(),
        legend.position = "bottom",
        axis.title.x = element_blank(),
        legend.title = element_blank()) +
  ylab("Support for Prabowo (%)") +
  xlab("Respondent Age")

ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/media_age_plot.pdf", media_age_graph, width = 7, height = 5)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/media_age_plot.pdf", media_age_graph, width = 7, height = 5)



