



sikap_df <- dat
sikap_df <- haven::zap_labels(sikap_df)


remember_plot <-
  sikap_df %>%
  filter(week %in% c(12)) %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997\u2013)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981\u201396)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965\u201380)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944\u201364)"),
         age_cat = factor(age_cat, levels = c("Boomers\n(1944\u201364)", "Gen-X\n(1965\u201380)", 
                                              "Millenials\n(1981\u201396)", "Gen-Z\n(1997\u2013)")),
         vote_choice = coalesce(polpref_votepres, polpref_votepresb),
         vote_choice = case_when(vote_choice == 1 ~ "Anies Baswedan",
                                 vote_choice == 2 ~ "Prabowo Subianto",
                                 vote_choice == 3 ~ "Ganjar Pranowo",
                                 vote_choice == 4 ~ NA_character_),
         vote_choice = factor(vote_choice, levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))) %>%
  mutate(moments_memory_tragedy2pt = case_when(moments_memory_tragedy %in% c(4, 5) ~ 1,
                                               TRUE ~ 0),
         moments_memory_suharto2pt = case_when(moments_memory_suharto %in% c(4, 5) ~ 1,
                                               TRUE ~ 0),
         moments_memory_violence2pt = case_when(moments_memory_violence %in% c(4, 5) ~ 1,
                                               TRUE ~ 0)) %>%
  select(demog_age, age_cat, vote_choice, moments_memory_tragedy2pt:moments_memory_violence2pt) %>%
  pivot_longer(cols = moments_memory_tragedy2pt:moments_memory_violence2pt) %>%
  mutate(name = case_when(name == "moments_memory_tragedy2pt" ~ "Semanggi\nshootings",
                          name == "moments_memory_suharto2pt" ~ "Suharto\nresignation",
                          name == "moments_memory_violence2pt" ~ "Anti-Chinese\nriots")) %>%
  group_by(age_cat, name) %>%
  summarise(val = mean(value, na.rm = T)) %>%
  filter(name != "Suharto\nresignation") %>%
  ggplot(aes(x=fct_rev(age_cat), y = val*100, fill = factor(age_cat))) +
  geom_bar(stat = 'identity', color = "black", position = "dodge") +
  facet_wrap(name  ~ ., ncol = 3) +
  scale_fill_grey() +
  geom_text(aes(label = paste0(round(val*100, digits = 0), "%"), y = -3), size = 3, family = "new_bask") +
  theme_bw()+ 
  theme(axis.line.x.bottom = element_line(color = "black"),
        axis.line.y.left = element_blank(),
        panel.grid.major = element_blank(),
        panel.grid.minor.x = element_blank(),
        legend.position = "none",
        strip.background = element_blank(),
        axis.title = element_blank(),
        legend.title = element_blank(),
        panel.border = element_blank(),
        axis.ticks = element_blank(),
        text=element_text(size=10, family="new_bask"))
  
  
ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/age_remember.pdf", remember_plot, width = 115, height = 57, units = "mm", dpi = 1600)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/age_remember.pdf", remember_plot, width = 115, height = 57, units = "mm", dpi = 1600)
  
support_prabowo_memory <-
  sikap_df %>%
  filter(week %in% c(12)) %>%
  mutate(birthyear = 2024 - as.numeric(demog_age),
         age_cat = case_when(birthyear %in% seq(1997, 2012, 1) ~ "Gen-Z\n(1997\u2013)",
                             birthyear %in% seq(1981, 1996, 1) ~ "Millenials\n(1981\u201396)",
                             birthyear %in% seq(1965, 1980, 1) ~ "Gen-X\n(1965\u201380)",
                             birthyear %in% seq(1944, 1964, 1) ~ "Boomers\n(1944\u201364)"),
         age_cat = factor(age_cat, levels = c("Boomers\n(1944\u201364)", "Gen-X\n(1965\u201380)", 
                                              "Millenials\n(1981\u201396)", "Gen-Z\n(1997\u2013)")),
         vote_choice = coalesce(polpref_votepres, polpref_votepresb),
         vote_choice = case_when(vote_choice == 1 ~ "Anies Baswedan",
                                 vote_choice == 2 ~ "Prabowo Subianto",
                                 vote_choice == 3 ~ "Ganjar Pranowo",
                                 vote_choice == 4 ~ NA_character_),
         vote_choice = factor(vote_choice, levels = c("Anies Baswedan", "Prabowo Subianto", "Ganjar Pranowo"))) %>%
  mutate(moments_memory_tragedy2pt = case_when(moments_memory_tragedy %in% c(4, 5) ~ 1,
                                               TRUE ~ 0),
         moments_memory_suharto2pt = case_when(moments_memory_suharto %in% c(4, 5) ~ 1,
                                               TRUE ~ 0),
         moments_memory_violence2pt = case_when(moments_memory_violence %in% c(4, 5) ~ 1,
                                                TRUE ~ 0)) %>%
  select(demog_age, age_cat, vote_choice, moments_memory_tragedy2pt:moments_memory_violence2pt) %>%
  pivot_longer(cols = moments_memory_tragedy2pt:moments_memory_violence2pt) %>%
  mutate(name = case_when(name == "moments_memory_tragedy2pt" ~ "Semanggi\nshootings",
                          name == "moments_memory_suharto2pt" ~ "Suharto\nresignation",
                          name == "moments_memory_violence2pt" ~ "Anti-Chinese\nriots")) %>%
  group_by(age_cat, value, name) %>%
  summarise(val = mean(vote_choice == "Prabowo Subianto", na.rm = T)) %>%
  mutate(value = case_when(value == 1 ~ "Remembers",
                           value == 0 ~ "Does not remember")) %>%
  filter(name != "Suharto\nresignation") %>%
  ggplot(aes(x=fct_rev(age_cat), y = val*100, shape = factor(value), linetype = factor(value), group = factor(value))) +
  stat_summary_bin(geom = "point", bins = 8, inherit.aes = T) +
  stat_summary_bin(geom = "line", bins = 8) +
  facet_wrap(name  ~ ., ncol = 3) +
  scale_color_grey() +
  theme_bw()+ 
  theme(axis.line.x.bottom = element_line(color = "black"),
        axis.line.y.left = element_blank(),
        panel.grid.major = element_blank(),
        panel.grid.minor.x = element_blank(),
        legend.position = "bottom",
        strip.background = element_blank(),
        axis.title.x = element_blank(),
        legend.title = element_blank(),
        panel.border = element_blank(),
        axis.ticks = element_blank(),
        text=element_text(size=9, family="new_bask")) +
  ylab("Support for Prabowo (%)")
  
ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/support_prabowo_memory.pdf", support_prabowo_memory, width = 115, height = 57, units = "mm", dpi = 1600)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/support_prabowo_memory.pdf", support_prabowo_memory, width = 115, height = 57, units = "mm", dpi = 1600)


