pileg2019 <- read.csv("~/Dropbox/candidate_survey/replication_file/data/scraped_data/pileg_candidates_2019.csv")
pileg2024 <- read_csv("~/Dropbox/candidate_survey/replication_file/data/scraped_data/candidate_pileg_data_2024.csv")

Sys.setlocale("LC_ALL", "C")

words <- c(" UMAT| DAKWAH| SHARIA| ALLAH| SYARIAT")

sum19 <-
  pileg2019 %>%
  filter(platform != "") %>%
  filter(name != "NASRIL BAHAR, SE") %>%
  mutate(platform = toupper(platform)) %>%
  group_by(level) %>%
  summarise(val = mean(str_detect(platform, words), na.rm = T)) %>% 
  mutate(year = 2019)

sum24 <-
  pileg2024 %>%
  filter(platform != "") %>%
  #filter(party_name != "Partai Ummat") %>%
  group_by(level) %>%
  summarise(val = mean(str_detect(toupper(platform),words), na.rm = T)) %>%
  mutate(year = 2024)



religious_platforms <-
  bind_rows(sum19, sum24) %>%
  ggplot(aes(x=level, y = val*100, fill = factor(year), group = factor(year))) +
  geom_bar(stat = "identity", position = "dodge", color = "black") +
  theme_bw() +
  scale_fill_manual(values = c("#E3B448", "#B85042", "#3A6B35")) +
  theme(panel.grid.minor = element_blank(), 
        panel.grid.major.x = element_blank(),
        axis.line = element_line(colour = "black"),
        panel.border = element_blank(),
        legend.position = "bottom",
        legend.title = element_blank(),
        axis.title.x = element_blank()) +
  geom_text(aes(x=level, y = val*100 + 0.1, label = paste0(round(val*100, 1), "%")), position = position_dodge(width = 1)) +
  ylab("Campaign Platforms Mentioning\nReligious Themes (%)")

getwd()

ggsave("~/Dropbox/2024 Indonesia Election/replication_file/outputs/religious_platforms.pdf", religious_platforms, width = 7, height = 4)
ggsave("~/Dropbox/Apps/Overleaf/2024 Indonesia Election/figures/religious_platforms.pdf", religious_platforms, width = 7, height = 4)
